<?php declare(strict_types = 1);

namespace InfoPanels\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\Event\EventDispatcher;
use Core\Model\Event\TTPreload;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use InfoPanels\AdminModule\Model\PanelsService as AdminPanelsService;
use InfoPanels\FrontModule\Model\PanelsService;
use Override;

class InfoPanel extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'infoPanelsByPanel';

	public function __construct(
		protected PanelsService      $panelsService,
		protected AdminPanelsService $adminPanelsService,
		protected EventDispatcher    $eventDispatcher,
	)
	{
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 * @param array         $texts
	 */
	#[Override]
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$formContainer->addCheckboxList($this->getName(), $this->getTitle(), ['' => ''] + $this->adminPanelsService->getOptionsForSelect());
	}

	#[Override]
	public function render(array $params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		if (!$this->getDefault() && isset($params['default'])) {
			$this->setDefault($params['default']);
		}

		if (is_numeric($this->getDefault())) {
			$this->setDefault([$this->getDefault()]);
		}

		/** @var int|string|array $default */
		$default = $this->getDefault();

		$result = $this->panelsService->get($default);
		if (!$result) {
			return null;
		}

		if (is_array($default)) {
			$result = [$result];
		}

		$this->eventDispatcher->dispatch(new TTPreload([], (array) $result, $params, 'infoPanels'), 'infoPanels.ttPreload');

		if (!$params['multiple']) {
			/** @phpstan-ignore-next-line */
			return array_values((array) $result)[0] ?? null;
		}

		return $result;
	}
}
