<?php declare(strict_types = 1);

namespace InfoPanels\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Annotation\Controller\RequestParameter;
use Apitte\Core\Annotation\Controller\RequestParameters;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use InfoPanels\FrontModule\Model\PanelsService;

/**
 * @Path("/panels")
 */
class PanelsController extends BaseController
{
	protected PanelsService $panelsService;

	public function __construct(PanelsService $panelsService)
	{
		$this->panelsService = $panelsService;
	}

	/**
	 * @Path("/get/{id}")
	 * @Method("GET")
	 * @RequestParameters({
	 *      @RequestParameter(name="id", type="int", required=true)
	 * })
	 */
	public function get(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		$infoPanel = $this->panelsService->get((int) $request->getParameter('id'));
		return $response->writeJsonBody(['infoPanel' => $infoPanel])->withStatus(ApiResponse::S200_OK);
	}

}