<?php declare(strict_types = 1);

namespace InfoPanels\FrontModule\Model\Dao;

use DateTimeInterface;

class Message
{
	/**
	 * @var DateTimeInterface|null
	 */
	public        $modified    = null;
	public int    $id;
	public string $title;
	public string $template;
	public array  $texts       = [];
	public array  $parsedTexts = [];

	public function __construct(int $id, string $title, string $template)
	{
		$this->id       = $id;
		$this->title    = $title;
		$this->template = $template;
	}

	public function getId(): int { return $this->id; }

	/**
	 * @return DateTimeInterface|null
	 */
	public function getModified() { return $this->modified; }

	public function getTexts(): array { return $this->texts; }

	/**
	 * @param mixed $text
	 *
	 * @return mixed|null
	 */
	public function getText($text) { return $this->texts[$text] ?? null; }

	public function getParsedTexts(): array { return $this->parsedTexts; }

	/**
	 * @return mixed|null
	 */
	public function getParsed(string $key) { return $this->parsedTexts[$key] ?? null; }
}
