<?php declare(strict_types = 1);

namespace InfoPanels\FrontModule\Model\Subscribers;

use Core\Model\Event\PartRenderEvent;
use InfoPanels\FrontModule\Model\PanelsService;
use InfoPanels\Model\Entities\Message;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class DefaultPlacesSubscriber implements EventSubscriberInterface
{
	protected PanelsService $panelsService;

	public function __construct(
		PanelsService $panelsService
	)
	{
		$this->panelsService = $panelsService;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'partRender' => 'partRender',
		];
	}

	public function partRender(PartRenderEvent $event): void
	{
		$panels = $this->panelsService->get($event->getKey());

		if ($panels === null) {
			return;
		}

		foreach (is_array($panels) ? $panels : [$panels] as $panel) {
			foreach ($panel->messages as $message) {
				$event->addRenderTemplate(Message::TEMPLATES_DIR . DS . $message->template, ['templateTextValues' => $message->getTexts()]);
			}
		}
	}
}
