<?php declare(strict_types = 1);

namespace InfoPanels\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\TemplateReader\Entity\TTemplate;
use Core\Model\TemplateReader\Entity\ITemplate;
use DateTime;
use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="infopanel__message", indexes={@ORM\Index(name="published", columns={"panel_id", "is_published"})})
 * @ORM\Entity
 * @ORM\EntityListeners({"InfoPanels\Model\Listeners\MessageListener"})
 */
class Message implements ITemplate
{
	use TId;
	use TTemplate;

	public const TEMPLATES_DIR = TEMPLATES_DIR . '/Front/default/InfoPanels/Templates';

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $title;

	/**
	 * @var int
	 * @ORM\Column(type="smallint", nullable=false)
	 */
	public $isPublished;

	/**
	 * @ORM\ManyToOne(targetEntity="Panel", inversedBy="messages")
	 * @ORM\JoinColumn(name="panel_id", referencedColumnName="id", nullable=false)
	 */
	public Panel $panel;

	/**
	 * @Gedmo\Timestampable(on="update")
	 * @ORM\Column(type="datetime", nullable=true, options={"default": "CURRENT_TIMESTAMP"})
	 */
	private DateTimeInterface $modified;

	public function __construct(string $title, Panel $panel, string $template)
	{
		$this->title       = $title;
		$this->template    = $template;
		$this->isPublished = 1;
		$this->panel       = $panel;
		$this->texts       = [];
		$this->modified    = new DateTime;
	}

	public function getModified(): DateTimeInterface { return $this->modified; }
}
