<?php declare(strict_types = 1);

namespace InfoPanels\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * @ORM\Table(name="infopanel__panel", indexes={@ORM\Index(name="published", columns={"id", "is_published"})})
 * @ORM\Entity
 * @ORM\EntityListeners({"InfoPanels\Model\Listeners\PanelListener"})
 */
class Panel
{
	use TId;

	/**
	 * @ORM\Column(type="string", length=255)
	 */
	public string $title;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	protected ?string $positions = null;

	/**
	 * @var Collection<Message>
	 * @ORM\OneToMany(targetEntity="Message", mappedBy="panel")
	 */
	public Collection $messages;

	/**
	 * @var int
	 * @ORM\Column(type="smallint", options={"default":1})
	 */
	public $isPublished;

	public function __construct(string $title)
	{
		$this->title       = $title;
		$this->isPublished = 1;
		$this->messages    = new ArrayCollection;
	}

	/******
	 * === Messages
	 */

	/**
	 * @return Collection<Message>
	 */
	public function getMessages(): Collection { return $this->messages; }

	/**
	 * @param Message[] $messages
	 */
	public function setMessages(array $messages): self
	{
		$this->messages = new ArrayCollection($messages);

		return $this;
	}

	public function addMessage(Message $message): bool
	{
		if ($this->messages->contains($message)) {
			return true;
		}

		return $this->messages->add($message);
	}

	public function removeMessage(Message $message): bool
	{
		if ($this->messages->contains($message)) {
			return $this->messages->removeElement($message);
		}

		return true;
	}

	public function setPositions(array $position): void { $this->positions = implode(',', $position); }

	public function getPositions(): array { return explode(',', (string) $this->positions); }
}
