<?php declare(strict_types = 1);

namespace InfoPanels\Model\Listeners;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use InfoPanels\Model\Entities\Message;
use InfoPanels\Model\Entities\Panel;
use InfoPanels\Model\PanelsCache;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class MessageListener implements EventSubscriberInterface
{
	protected PanelsCache $panelsCache;

	public function __construct(
		PanelsCache $panelsCache
	)
	{
		$this->panelsCache = $panelsCache;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @param Message $entity
	 *
	 * @ORM\PostPersist
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 */
	public function postHandler($entity, LifecycleEventArgs $event): void
	{
		$em = $event->getEntityManager();

		$changeSet = $em->getUnitOfWork()->getEntityChangeSet($entity);
		if (isset($changeSet['panel'])) {
			$panels = $changeSet['panel'];
		} else {
			$panels = [$entity->panel];
		}

		foreach ($panels as $panel) {
			if (!$panel) {
				continue;
			}

			/** @var Panel $panel */
			$this->panelsCache->getCache()->remove('panel/' . $panel->getId());

			foreach ($panel->getPositions() as $pos) {
				$this->panelsCache->getCache()->remove('panel/' . $pos);
			}
		}
	}
}
