<?php declare(strict_types = 1);

namespace InfoPanels\Model\Subscribers;

use Core\Model\Event\TTPreload;
use Core\Model\SystemConfig;
use Core\Model\TemplateReader\TemplateReader;
use InfoPanels\FrontModule\Model\Dao\Panel;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class TemplateSubscriber implements EventSubscriberInterface
{
	protected TemplateReader $templateReader;

	protected static array $loadedTemplateInputs = [];

	public function __construct(
		TemplateReader $templateReader
	)
	{
		$this->templateReader = $templateReader;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'infoPanels.ttPreload' => 'ttPreload',
		];
	}

	public function ttPreload(TTPreload $event): void
	{
		/** @var Panel[] $rawData */
		$rawData = $event->rawData;

		if (!empty($rawData)) {
			$this->templateReader->setTemplatesDir(sprintf('%s/Front/default/InfoPanels/Templates/', TEMPLATES_DIR));

			foreach ($rawData as $panel) {
				foreach ($panel->messages as $message) {
					$templateInputs = $this->templateReader->getTemplateInputs($message->template);
					$data           = $this->templateReader->readRawData($message->getTexts(), $templateInputs);

					$message->parsedTexts = $data;
				}
			}
		}
	}
}
