<?php declare(strict_types = 1);

namespace InfoPanels\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\Event\EventDispatcher;
use Core\Model\Event\TTPreload;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use InfoPanels\AdminModule\Model\PanelsService as AdminPanelsService;
use InfoPanels\FrontModule\Model\PanelsService;

class InfoPanel extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'infoPanelsByPanel';

	protected PanelsService      $panelsService;
	protected AdminPanelsService $adminPanelsService;
	protected EventDispatcher    $eventDispatcher;

	public function __construct(
		PanelsService      $panelsService,
		AdminPanelsService $adminPanelsService,
		EventDispatcher    $eventDispatcher
	)
	{
		$this->panelsService      = $panelsService;
		$this->adminPanelsService = $adminPanelsService;
		$this->eventDispatcher    = $eventDispatcher;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 * @param array         $texts
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$formContainer->addCheckboxList($this->getName(), $this->getTitle(), ['' => ''] + $this->adminPanelsService->getOptionsForSelect());
	}

	public function render(array $params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		if (!$this->getDefault() && isset($params['default'])) {
			$this->setDefault($params['default']);
		}

		if (is_numeric($this->getDefault())) {
			$this->setDefault([$this->getDefault()]);
		}

		$result = $this->panelsService->get($this->getDefault());
		if (!$result) {
			return null;
		}

		if (is_array($this->getDefault())) {
			$result = [$result];
		}

		$this->eventDispatcher->dispatch(new TTPreload([], $result, $params, 'infoPanels'), 'infoPanels.ttPreload');

		if (!$params['multiple']) {
			return array_values($result)[0] ?? null;
		}

		return $result;
	}
}
