<?php declare(strict_types = 1);

namespace InfoPanels\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use InfoPanels\Model\Entities\Message;

/**
 * @method Message|object|null getReference($id)
 * @method Message[]|null getAll()
 * @method Message|null get($id)
 */
class MessagesService extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Message::class;

	public function getTemplatesDir(): string { return Message::getTemplatesDir(); }

	public function getTemplateFile(string $name): string { return $this->getTemplatesDir() . '/' . $name; }
}
