<?php declare(strict_types = 1);

namespace InfoPanels\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use InfoPanels\AdminModule\Components\IMessageFormFactory;
use InfoPanels\AdminModule\Components\IMessagesGridFactory;
use InfoPanels\AdminModule\Components\IPanelFormFactory;
use InfoPanels\AdminModule\Components\IPanelsGridFactory;
use InfoPanels\AdminModule\Components\MessageForm;
use InfoPanels\AdminModule\Components\MessagesGrid;
use InfoPanels\AdminModule\Components\PanelForm;
use InfoPanels\AdminModule\Components\PanelsGrid;
use InfoPanels\Model\Entities\Message;
use InfoPanels\Model\Entities\Panel;
use Nette\Application\BadRequestException;
use Override;

class DefaultPresenter extends BasePresenter
{
	#[Override]
	protected function startup()
	{
		parent::startup();
		$this->setHeader('infoPanels.title.infoPanels', 'fas fa-info-circle');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'infoPanels.menu.addMessage',
				'link'  => 'Default:addMessage',
				'ico'   => 'plus',
			], [
				'title' => 'infoPanels.menu.addPanel',
				'link'  => 'Default:addPanel',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAddMessage(): void
	{
		$this->setHeader('infoPanels.title.addMessage', 'fas fa-info-circle');
	}

	/**
	 * @param int|string $id
	 *
	 * @throws BadRequestException
	 */
	public function actionEditMessage($id): void
	{
		$message = $this->em->getRepository(Message::class)->find($id);

		if (!$message) {
			$this->error();
		}

		$this->setTitle($this->translator->translate('infoPanels.title.editMessage'), $message->title);
		$this->setHeader('infoPanels.title.editMessage', 'fas fa-info-circle');
	}

	public function actionAddPanel(): void
	{
		$this->setHeader('infoPanels.title.addPanel', 'fas fa-info-circle');
	}

	/**
	 * @param int|string $id
	 *
	 * @throws BadRequestException
	 */
	public function actionEditPanel($id): void
	{
		$panel = $this->em->getRepository(Panel::class)->find($id);

		if (!$panel) {
			$this->error();
		}

		$this->setTitle($this->translator->translate('infoPanels.title.editPanel'), $panel->title);
		$this->setHeader('infoPanels.title.editPanel', 'fas fa-info-circle');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentPanelsGrid(IPanelsGridFactory $factory): PanelsGrid
	{
		return $factory->create();
	}

	protected function createComponentPanelForm(IPanelFormFactory $factory): PanelForm
	{
		$control = $factory->create();

		$paramId = $this->getParameters()['id'] ?? null;
		if ($paramId) {
			$control->setPanel((int) $paramId);
		}

		$control['form']->onSuccessSave[]         = function(BaseForm $form): void {
			$this->redirect('editPanel', $form->getCustomData('panelId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(): void {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function(): void {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentMessagesGrid(IMessagesGridFactory $factory): MessagesGrid
	{
		return $factory->create();
	}

	protected function createComponentMessageForm(IMessageFormFactory $factory): MessageForm
	{
		$control = $factory->create();

		$paramId = $this->getParameters()['id'] ?? null;
		if ($paramId) {
			$control->setMessage((int) $paramId);
		}

		$control['form']->onSuccessSave[]         = function(BaseForm $form): void {
			$this->redirect('editMessage', $form->getCustomData('messageId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(): void {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function(): void {
			$this->redirect('default');
		};

		return $control;
	}

}
