<?php declare(strict_types = 1);

namespace InfoPanels\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Annotation\Controller\RequestParameter;
use Apitte\Core\Annotation\Controller\RequestParameters;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use InfoPanels\FrontModule\Model\PanelsService;

/**
 * @Path("/panels")
 */
class PanelsController extends BaseController
{
	public function __construct(
		protected PanelsService $panelsService,
	)
	{
	}

	/**
	 * @Path("/get/{id}")
	 * @Method("GET")
	 * @RequestParameters({
	 *      @RequestParameter(name="id", type="int", required=true)
	 * })
	 */
	public function get(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		/** @var int $paramId */
		$paramId = $request->getParameter('id');

		$infoPanel = $this->panelsService->get($paramId);

		return $response->writeJsonBody(['infoPanel' => $infoPanel])->withStatus(ApiResponse::S200_OK);
	}
}
