<?php declare(strict_types = 1);

namespace InfoPanels\FrontModule\Model\Dao;

use DateTime;

class Message
{
	public ?DateTime $modified    = null;
	public array     $texts       = [];
	public array     $parsedTexts = [];

	public function __construct(
		public int    $id,
		public string $title,
		public string $template,
	)
	{
	}

	public function getId(): int { return $this->id; }

	public function getModified(): ?DateTime { return $this->modified; }

	public function getTexts(): array { return $this->texts; }

	public function getText(mixed $text): mixed { return $this->texts[$text] ?? null; }

	public function getParsedTexts(): array { return $this->parsedTexts; }

	public function getParsed(string $key): mixed { return $this->parsedTexts[$key] ?? null; }
}
