<?php declare(strict_types = 1);

namespace InfoPanels\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\TemplateReader\Entity\ITemplate;
use Core\Model\TemplateReader\Entity\TTemplate;
use DateTime;
use DateTimeInterface;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use InfoPanels\Model\Listeners\MessageListener;

#[ORM\Table(name: 'infopanel__message')]
#[ORM\Index(columns: ['panel_id', 'is_published'], name: 'published')]
#[ORM\Entity]
#[ORM\EntityListeners([MessageListener::class])]
class Message implements ITemplate
{
	use TId;
	use TTemplate;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $title;

	#[ORM\Column(type: Types::SMALLINT, nullable: false)]
	public int $isPublished = 0;

	#[ORM\JoinColumn(name: 'panel_id', referencedColumnName: 'id', nullable: false)]
	#[ORM\ManyToOne(targetEntity: Panel::class, inversedBy: 'messages')]
	public Panel $panel;

	/** @Gedmo\Timestampable(on="update") */
	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true, options: ['default' => 'CURRENT_TIMESTAMP'])]
	private DateTimeInterface $modified;

	public function __construct(string $title, Panel $panel, string $template)
	{
		$this->title       = $title;
		$this->template    = $template;
		$this->isPublished = 1;
		$this->panel       = $panel;
		$this->texts       = [];
		$this->modified    = new DateTime;
	}

	public function getModified(): DateTimeInterface { return $this->modified; }

	public static function getTemplatesDir(): string
	{
		return TEMPLATES_DIR . '/Front/default/InfoPanels/Templates';
	}
}
