<?php declare(strict_types = 1);

namespace InfoPanels\Model\Listeners;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use InfoPanels\Model\Entities\Message;
use InfoPanels\Model\Entities\Panel;
use InfoPanels\Model\PanelsCache;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class MessageListener implements EventSubscriberInterface
{
	public function __construct(
		protected PanelsCache            $panelsCache,
		protected EntityManagerDecorator $em,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @param Message $entity
	 */
	#[ORM\PostPersist]
	#[ORM\PostUpdate]
	#[ORM\PostRemove]
	public function postHandler($entity, LifecycleEventArgs $event): void
	{
		$changeSet = $this->em->getUnitOfWork()->getEntityChangeSet($entity);
		$panels    = $changeSet['panel'] ?? [$entity->panel];

		foreach ($panels as $panel) {
			if (!$panel) {
				continue;
			}

			/** @var Panel $panel */
			$this->panelsCache->getCache()->remove('panel/' . $panel->getId());

			foreach ($panel->getPositions() as $pos) {
				$this->panelsCache->getCache()->remove('panel/' . $pos);
			}
		}
	}
}
