<?php declare(strict_types = 1);

namespace InfoPanels\Model\Listeners;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use InfoPanels\Model\Entities\Panel;
use InfoPanels\Model\PanelsCache;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class PanelListener implements EventSubscriberInterface
{
	public function __construct(
		protected PanelsCache            $panelsCache,
		protected EntityManagerDecorator $em,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @param Panel $entity
	 */
	#[ORM\PostPersist]
	#[ORM\PostUpdate]
	#[ORM\PostRemove]
	public function postHandler($entity, LifecycleEventArgs $event): void
	{
		/** @var array[] $changeSet */
		$changeSet = $this->em->getUnitOfWork()->getEntityChangeSet($entity);
		if (isset($changeSet['positions'])) {
			$positions = array_merge(
				explode(',', (string) $changeSet['positions'][0]),
				explode(',', (string) $changeSet['positions'][1]),
			);
			$positions = array_unique($positions);
		} else {
			$positions = $entity->getPositions();
		}

		$this->panelsCache->getCache()->remove('panel/' . $entity->getId());

		foreach ($positions as $pos) {
			$this->panelsCache->getCache()->remove('panel/' . $pos);
		}
	}
}
