<?php declare(strict_types = 1);

namespace Intranet\DI;

use Core\DI\CompilerExtension;

class IntranetExtension extends CompilerExtension
{

	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['Intranet' => 'Intranet\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();
	}
}
