<?php declare(strict_types = 1);

namespace Intranet\Model;

use Core\Model\Helpers\BaseEntityService;
use Intranet\Model\Entities\File;

/**
 * @method File|null|object getReference($id)
 * @method File[]|null getAll()
 * @method File|null get($id)
 */
class FilesService extends BaseEntityService
{
	/** @var string */
	protected $entityClass = File::class;

	/**
	 * @return File[]
	 */
	public function getFilesWithoutFolder(): array
	{
		return $this->getEr()->findBy(['folder' => null, 'status' => File::STATUS_PUBLISHED]);
	}

	public function remove($id)
	{
		if ($entity = $this->get($id)) {
			$file = $entity->getFilePath();
			if (file_exists($file) && !is_dir($file)) {
				unlink($file);
			}

			return parent::remove($id);
		}

		return false;
	}
}
