<?php declare(strict_types = 1);

namespace Intranet\Model;

use Core\Model\Helpers\BaseEntityService;
use Intranet\Model\Entities\Folder;
use Intranet\Model\Entities\FolderRepository;

/**
 * @method Folder|null|object getReference($id)
 * @method Folder[]|null getAll()
 * @method Folder|null get($id)
 * @method FolderRepository getEr()
 */
class FoldersService extends BaseEntityService
{
	/** @var string */
	protected $entityClass = Folder::class;

	/**
	 * @return Folder[]
	 */
	public function getTopLvl()
	{
		return $this->getEr()->findBy(['lvl' => 0, 'status' => Folder::STATUS_PUBLISHED]);
	}

	/**
	 * @return Folder[]
	 */
	public function getChildrens($parent)
	{
		return $this->getEr()->findBy(['parent' => $parent, 'status' => Folder::STATUS_PUBLISHED]);
	}

	public function remove($id)
	{
		if ($entity = $this->get($id)) {
			if ($entity->getFiles()->toArray()) {
				throw new \Exception('folderContainFiles');
			} else if ($entity->getChildrens()->toArray()) {
				throw new \Exception('folderContainFolders');
			}

			return parent::remove($id);
		}

		return false;
	}

	public function getFoldersForSelect()
	{
		$data = [];
		$this->foldersForSelectLoop($data, $this->getEr()->childrenHierarchy());

		return $data;
	}

	protected function foldersForSelectLoop(&$data, $array, $deep = 0)
	{
		$prefix = str_repeat('-', $deep) . ($deep ? ' ' : '');

		foreach ($array as $folder) {
			$data[$folder['id']] = $prefix . $folder['title'];
			if (!empty($folder['__children'])) {
				$this->foldersForSelectLoop($data, $folder['__children'], $deep + 1);
			}
		}
	}
}
