<?php declare(strict_types = 1);

namespace Mall\DI;

use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;
use Override;

class MallExtension extends CompilerExtension
{
	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['Mall' => 'Mall\*Module\Presenters\*Presenter']);
		$this->getContainerBuilder();
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->getMethod('initialize');

		$init->addBody('Mall\Model\MallConfig::setParams($this->parameters[\'mall\']);');
	}
}
