<?php declare(strict_types = 1);

namespace Mall\DI;

use Core\DI\CompilerExtension;
use Nette;

class MallExtension extends CompilerExtension
{
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['Mall' => 'Mall\*Module\Presenters\*Presenter']);
		$builder = $this->getContainerBuilder();
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->methods['initialize'];

		$init->addBody('Mall\Model\MallConfig::setParams($this->parameters[\'mall\']);');
	}
}
