<?php declare(strict_types = 1);

namespace Mall\Model\Dao;

use Currency\Model\Entities\Currency;
use Mall\Model\Dao\Product\Product;

class MallClient
{
	protected string $country;

	protected string $clientId;

	protected string $endPoint;

	protected string $locale;

	protected string $eshop;

	public string $defaultStage = 'live';

	public ?string $imagesDomain = null;

	public string $currency = 'czk';

	public string $mallDomain = '';

	public ?int $ulozenka = null;

	public string $invoiceId = '';

	public bool $testOrders = false;

	public int  $updateProductApiLimit      = 40000;
	public int  $updateAvailabilityApiLimit = 2000;
	public bool $allowAssort                = true;

	public ?Currency $currencyEntity = null;

	public function __construct(string $country, string $clientId, string $endPoint, string $locale, string $eshop)
	{
		$this->country  = $country;
		$this->clientId = $clientId;
		$this->endPoint = $endPoint;
		$this->locale   = $locale;
		$this->eshop    = $eshop;
	}

	public function getCountry(): string { return $this->country; }

	public function getClientId(): string { return $this->clientId; }

	public function getEndPoint(): string { return $this->endPoint; }

	public function getLocale(): string { return $this->locale; }

	public function getEshop(): string { return $this->eshop; }
}
