<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Manufacturer;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__allowed_manufacturer")
 */
class AllowedManufacturer
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Category", inversedBy="allowedManufacturers")
	 * @ORM\JoinColumn(name="category_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Category $category;

	/**
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Manufacturer")
	 * @ORM\JoinColumn(name="manufacturer_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Manufacturer $manufacturer;

	public function __construct(Category $category, Manufacturer $manufacturer)
	{
		$this->category     = $category;
		$this->manufacturer = $manufacturer;
	}

	public function getCategory(): Category { return $this->category; }

	public function getManufacturer(): Manufacturer { return $this->manufacturer; }
}
