<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use Core\Model\Entities\TId;
use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__api_call")
 */
class ApiCall
{
	use TId;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	protected string $name;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	protected string $mallId;

	/**
	 * @ORM\Column(name="`value`", type="text", nullable=false, options={"default": 0})
	 */
	public int $value = 0;

	/**
	 * @ORM\Column(name="`date`", type="date", nullable=true)
	 */
	public ?DateTimeInterface $date = null;

	public function __construct(string $name, string $mallId)
	{
		$this->name   = $name;
		$this->mallId = $mallId;
		$this->date   = new DateTime;
	}

	public function getMallId(): string { return $this->mallId; }

	public function getName(): string { return $this->name; }

}