<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__category")
 */
class Category
{
	use TId;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	protected string $mallId;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	protected string $country;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	protected ?string $title = null;

	/**
	 * @var Collection<int, CategoryMap>
	 * @ORM\OneToMany(targetEntity="CategoryMap", mappedBy="mallCategory", indexBy="category_id")
	 */
	public Collection $mapped;

	/**
	 * @var Collection<int, Param>
	 * @ORM\OneToMany(targetEntity="Param", mappedBy="category", indexBy="mall_id")
	 */
	public Collection $params;

	/**
	 * @var Collection<int, AllowedManufacturer>
	 * @ORM\OneToMany(targetEntity="AllowedManufacturer", mappedBy="category", indexBy="manufacturer_id")
	 */
	public Collection $allowedManufacturers;

	/**
	 * @ORM\Column(type="smallint", nullable=false, options={"default": 0, "unsigned": true})
	 */
	public int $isAvailable = 0;

	public function __construct(string $mallId, string $country, ?string $title = null)
	{
		$this->mallId               = $mallId;
		$this->country              = $country;
		$this->title                = $title;
		$this->mapped               = new ArrayCollection;
		$this->params               = new ArrayCollection;
		$this->allowedManufacturers = new ArrayCollection();
	}

	public function getMallId(): string { return $this->mallId; }

	public function getCountry(): string { return $this->country; }

	public function getTitle(): ?string { return $this->title; }

}
