<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Category as EshopCategory;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__category_map")
 */
class CategoryMap
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Category", inversedBy="mapped")
	 * @ORM\JoinColumn(name="mall_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Category $mallCategory;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Category")
	 * @ORM\JoinColumn(name="category_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected EshopCategory $category;

	public function __construct(Category $mallCategory, EshopCategory $category)
	{
		$this->mallCategory = $mallCategory;
		$this->category     = $category;
	}

	public function getMallCategory(): Category { return $this->mallCategory; }

	public function getCategory(): EshopCategory { return $this->category; }
}
