<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Spedition;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__delivery")
 */
class Delivery
{
	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", nullable=false)
	 */
	protected string $code;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	protected string $country;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $title;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $methodId;

	/**
	 * @ORM\ManyToOne(targetEntity="EshopOrders\Model\Entities\Spedition")
	 * @ORM\JoinColumn(name="spedition_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	public ?Spedition $eshopSpedition = null;

	public function __construct(string $code, string $country, string $title, string $methodId)
	{
		$this->code     = $code;
		$this->country  = $country;
		$this->title    = $title;
		$this->methodId = $methodId;
	}

	public function getCode(): string { return $this->code; }

	public function getCountry(): string { return $this->country; }

	public function getEshopSpeditionId(): ?int { return $this->eshopSpedition ? $this->eshopSpedition->getId() : null; }

}