<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use DateTime;
use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Order;
use Mall\Model\Dao\MallClient;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__order")
 */
class MallOrder
{
	public const STATUS_OPEN      = 'open';
	public const STATUS_SHIPPING  = 'shipping';
	public const STATUS_SHIPPED   = 'shipped';
	public const STATUS_DELIVERED = 'delivered';
	public const STATUS_RETURNED  = 'returned';
	public const STATUS_CANCELED  = 'canceled';
	public const STATUS_LOST      = 'lost';
	public const STATUS_STORNO    = 'storno';

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopOrders\Model\Entities\Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Order $order;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	protected string $mallId;

	/**
	 * @ORM\Column(type="string", length=2, nullable=true)
	 */
	public ?string $country = null;

	/**
	 * @ORM\Column(type="string", nullable=false, options={"default": "open"})
	 */
	public string $lastStatus = self::STATUS_OPEN;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $trackingNumber = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $trackingUrl = null;

	/**
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	protected ?DateTimeInterface $exported;

	public ?MallClient $mallClient = null;

	public function __construct(Order $order, string $mallId)
	{
		$this->order  = $order;
		$this->mallId = $mallId;
	}

	public function getOrder(): Order { return $this->order; }

	public function getMallId(): string { return $this->mallId; }

	public function getExported(): ?DateTimeInterface { return $this->exported; }

	public function export(): void { $this->exported = new DateTime; }

}