<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Seller;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__seller")
 */
class MallSeller
{
	/**
	 * @ORM\Id
	 * @ORM\Column(name="country", type="string", nullable=false)
	 */
	public string $country;

	/**
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Seller")
	 * @ORM\JoinColumn(name="seller_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	public ?Seller $seller = null;

	public function __construct(string $country)
	{
		$this->country = $country;
	}

	public function getEshopSellerId(): ?int { return $this->seller ? $this->seller->getId() : null; }

}