<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__param")
 */
class Param
{
	public const FEATURE_SUBCATEGORIES = 'subcategories';

	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Category", inversedBy="params")
	 * @ORM\JoinColumn(name="category_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Category $category;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	protected string $mallId;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	protected ?string $title = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	protected ?string $unit = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $feature = null;

	public function __construct(Category $category, string $mallId, ?string $title = null, ?string $unit = null)
	{
		$this->category = $category;
		$this->mallId   = $mallId;
		$this->title    = $title;
		$this->unit     = $unit;
	}

	public function getCategory(): Category { return $this->category; }

	public function getMallId(): string { return $this->mallId; }

	public function getTitle(): ?string { return $this->title; }

	public function getUnit(): ?string { return $this->unit; }
}
