<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use Core\Model\Helpers\Strings;
use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product as EshopProduct;
use Nette\Utils\DateTime;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__product_force_token")
 */
class ProductForceToken
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected EshopProduct $eshopProduct;

	/**
	 * @var float|string
	 * @ORM\Column(type="decimal", precision=10, scale=2, nullable=false)
	 */
	protected $priceTo;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	protected string $forceToken;

	/**
	 * @ORM\Column(type="datetime", nullable=false)
	 */
	protected DateTimeInterface $created;

	/**
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	protected ?DateTimeInterface $used = null;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", nullable=false)
	 */
	protected string $country;

	public function __construct(EshopProduct $eshopProduct, float $priceTo, string $forceToken, string $country)
	{
		$this->eshopProduct = $eshopProduct;
		$this->priceTo      = Strings::formatEntityDecimal($priceTo);
		$this->forceToken   = $forceToken;
		$this->country      = $country;
		$this->created      = new DateTime;
	}

	public function getEshopProduct(): EshopProduct { return $this->eshopProduct; }

	public function getPriceTo(): float { return $this->priceTo; }

	public function getForceToken(): string { return $this->forceToken; }

	public function getCreated(): DateTimeInterface { return $this->created; }

	public function getUsed(): DateTimeInterface { return $this->used; }

	public function use(): void { $this->used = new DateTime; }

	public function getCountry(): string { return $this->country; }

	public function reset(string $forceToken, float $priceTo): void
	{
		$this->created    = new DateTime;
		$this->used       = null;
		$this->forceToken = $forceToken;
		$this->priceTo    = Strings::formatEntityDecimal($priceTo);
	}

}