<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use Core\Model\Entities\TId;
use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__product_label")
 */
class ProductLabel
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Product $product;

	/**
	 * @ORM\ManyToOne(targetEntity="Label")
	 * @ORM\JoinColumn(name="label_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Label $label;

	/**
	 * @ORM\Column(name="`from`", type="datetime")
	 */
	public DateTimeInterface $from;

	/**
	 * @ORM\Column(name="`to`", type="datetime")
	 */
	public DateTimeInterface $to;

	public function __construct(Product $product, Label $label, DateTimeInterface $from, DateTimeInterface $to)
	{
		$this->product = $product;
		$this->label   = $label;
		$this->from    = $from;
		$this->to      = $to;
	}

}