<?php declare(strict_types = 1);

namespace Mall\Model\Entities;

use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Product as EshopProduct;

/**
 * @ORM\Entity
 * @ORM\Table(name="mall__product_map")
 */
class ProductMap
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected EshopProduct $eshopProduct;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="country", type="string", nullable=false)
	 */
	public string $country;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $mallId = null;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $idForMall = null;

	/**
	 * @ORM\Column(type="smallint", length=1, options={"unsigned": true, "default": 0})
	 */
	public int $isActive = 0;

	/**
	 * @var string|double|null
	 * @ORM\Column(type="decimal", precision=10, scale=2, nullable=true)
	 */
	public $price = null;

	/**
	 * @ORM\Column(name="update_date", type="datetime", nullable=true)
	 */
	public ?DateTimeInterface $updateDate = null;

	public function __construct(EshopProduct $product, string $country)
	{
		$this->eshopProduct = $product;
		$this->country      = $country;
	}

	public function getEshopProduct(): EshopProduct { return $this->eshopProduct; }

	public function getMallId(): ?string { return $this->mallId; }

	/**
	 * @return int|string|null
	 */
	public function getIdForMall() { return $this->idForMall ?: $this->eshopProduct->getId(); }
}
