<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200820144744 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE mall__product_map (country VARCHAR(255) NOT NULL, product_id INT NOT NULL, mall_id VARCHAR(255) NOT NULL, id_for_mall VARCHAR(255) DEFAULT NULL, INDEX IDX_E66E83C54584665A (product_id), PRIMARY KEY(product_id, country)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE mall__product_map ADD CONSTRAINT FK_E66E83C54584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE mall__category_map DROP FOREIGN KEY FK_8C4FBA5212469DE2');
		$this->addSql('ALTER TABLE mall__category_map DROP FOREIGN KEY FK_8C4FBA5297E071');
		$this->addSql('ALTER TABLE mall__category_map ADD CONSTRAINT FK_8C4FBA5212469DE2 FOREIGN KEY (category_id) REFERENCES eshop_catalog__category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE mall__category_map ADD CONSTRAINT FK_8C4FBA5297E071 FOREIGN KEY (mall_id) REFERENCES mall__category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE mall__param DROP FOREIGN KEY FK_B96C6A3112469DE2');
		$this->addSql('ALTER TABLE mall__param ADD CONSTRAINT FK_B96C6A3112469DE2 FOREIGN KEY (category_id) REFERENCES mall__category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE mall__product_label DROP FOREIGN KEY FK_FDA9E93F33B92F39');
		$this->addSql('ALTER TABLE mall__product_label DROP FOREIGN KEY FK_FDA9E93F4584665A');
		$this->addSql('ALTER TABLE mall__product_label ADD CONSTRAINT FK_FDA9E93F33B92F39 FOREIGN KEY (label_id) REFERENCES mall__label (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE mall__product_label ADD CONSTRAINT FK_FDA9E93F4584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE mall__product_promotion DROP FOREIGN KEY FK_A26B7464584665A');
		$this->addSql('ALTER TABLE mall__product_promotion ADD CONSTRAINT FK_A26B7464584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
		$this->addSql('CREATE TABLE mall__product_force_token (country VARCHAR(255) NOT NULL, product_id INT NOT NULL, price_to NUMERIC(10, 2) NOT NULL, force_token VARCHAR(255) NOT NULL, created DATETIME NOT NULL, used DATETIME DEFAULT NULL, INDEX IDX_8BC98D6F4584665A (product_id), PRIMARY KEY(product_id, country)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE mall__product_force_token ADD CONSTRAINT FK_8BC98D6F4584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON DELETE CASCADE');
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('DROP TABLE mall__product_force_token');
		$this->addSql('DROP TABLE mall__product_map');
		$this->addSql('ALTER TABLE mall__category_map DROP FOREIGN KEY FK_8C4FBA5297E071');
		$this->addSql('ALTER TABLE mall__category_map DROP FOREIGN KEY FK_8C4FBA5212469DE2');
		$this->addSql('ALTER TABLE mall__category_map ADD CONSTRAINT FK_8C4FBA5297E071 FOREIGN KEY (mall_id) REFERENCES mall__category (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('ALTER TABLE mall__category_map ADD CONSTRAINT FK_8C4FBA5212469DE2 FOREIGN KEY (category_id) REFERENCES eshop_catalog__category (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('ALTER TABLE mall__param DROP FOREIGN KEY FK_B96C6A3112469DE2');
		$this->addSql('ALTER TABLE mall__param ADD CONSTRAINT FK_B96C6A3112469DE2 FOREIGN KEY (category_id) REFERENCES mall__category (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('ALTER TABLE mall__product_label DROP FOREIGN KEY FK_FDA9E93F4584665A');
		$this->addSql('ALTER TABLE mall__product_label DROP FOREIGN KEY FK_FDA9E93F33B92F39');
		$this->addSql('ALTER TABLE mall__product_label ADD CONSTRAINT FK_FDA9E93F4584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('ALTER TABLE mall__product_label ADD CONSTRAINT FK_FDA9E93F33B92F39 FOREIGN KEY (label_id) REFERENCES mall__label (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
		$this->addSql('ALTER TABLE mall__product_promotion DROP FOREIGN KEY FK_A26B7464584665A');
		$this->addSql('ALTER TABLE mall__product_promotion ADD CONSTRAINT FK_A26B7464584665A FOREIGN KEY (product_id) REFERENCES eshop_catalog__product (id) ON UPDATE NO ACTION ON DELETE NO ACTION');
	}
}
