document.addEventListener('autocompleteOnSelection', e => {
	if (e.detail.name !== 'mallCategory')
		return;

	const resp       = e;
	const input      = resp.target;
	const allWrap    = input.closest('.mall-settings-grid__wrap');
	const addLink    = allWrap.dataset.add;
	const removeLink = allWrap.dataset.remove;
	const selection  = resp.detail.selection;

	global.naja.makeRequest('post', addLink, {
		id    : input.dataset.id,
		shopId: selection.value.id,
	}, {
		history: false,
	}).then(response => {
		if (response.result !== 'ok')
			return;

		input.value = '';

		let span         = document.createElement('span');
		span.textContent = selection.value.name;

		let btn       = document.createElement('a');
		btn.className = 'btn btn-xs btn-danger ajax';
		btn.setAttribute('href', 'javascript:;')
		btn.setAttribute('data-remove-link', removeLink);
		btn.setAttribute('data-id', input.dataset.id);
		btn.setAttribute('data-shop-id', selection.value.id);
		btn.innerHTML = '<i class="fas fa-times"></i>';

		let div = document.createElement('div');
		div.appendChild(span);
		div.appendChild(btn);

		input.parentElement.nextElementSibling.appendChild(div);
	});
})

document.addEventListener('click', e => {
	let target = e.target;
	if (target.dataset.id && target.dataset.shopId) {
		global.naja.makeRequest('post', target.dataset.removeLink, {
			id    : target.dataset.id,
			shopId: target.dataset.shopId,
		}, {
			history: false,
		}).then(response => {
			if (response.result !== 'ok')
				return;

			target.parentElement.remove();
		});
	}
})

document.addEventListener('focusin', e => {
	let select = e.target;
	if (select.dataset.paramId && select.mallChangeInited !== true && select.parentElement.classList.contains('mall-settings-grid__input-wrap')) {
		select.mallChangeInited = true;

		let options = '<option value=""></option>';
		for (let k in document.mallShopFeatures) {
			let v = document.mallShopFeatures[k];

			options +=
				'<option value="' + v.id + '"' + (select.value == v.id ? ' selected' : '') + '>' + v.title + '</option>'
		}
		select.innerHTML = options;

		select.addEventListener('change', e => {
			global.naja.makeRequest('post', select.closest('.mall-settings-grid__wrap').dataset.setLink, {
				paramId: select.dataset.paramId,
				feature: select.value,
			}, {
				history: false,
			});
		});
	}
})

document.addEventListener('change', e => {
	let select = e.target;

	if (select && select.dataset.deliveryLink) {
		const country = select.dataset.country;
		const code    = select.dataset.code;

		if (!country || !code)
			return;

		global.naja.makeRequest('post', select.dataset.deliveryLink, {
			country  : country,
			code     : code,
			spedition: select.value,
		}, {
			history: false,
		});
	}

	if (select && select.dataset.sellerLink) {

		global.naja.makeRequest('post', select.dataset.sellerLink, {
			seller: select.value,
		}, {
			history: false,
		});
	}

});
