<?php declare(strict_types = 1);

namespace Mall\AdminModule\Components\Accountant;

use Core\Model\Http\CsvResponse;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Mall\AdminModule\Model\AccountantService;
use Nette\Utils\ArrayHash;
use Nette\Utils\DateTime;

class ExportForm extends BaseControl
{
	protected string $country;

	protected AccountantService $accountantService;

	public function __construct(string $country, AccountantService $accountantService)
	{
		$this->country           = $country;
		$this->accountantService = $accountantService;
	}

	public function render(): void
	{
		$this->template->thisForm = $this['form'];
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setShowLangSwitcher(false);

		$today = new DateTime();

		$form->addDatePicker('from', 'mall.accountant.export.from')
			->setDefaultValue($today->modifyClone('first day of this month'));
		$form->addDatePicker('to', 'mall.accountant.export.to')
			->setDefaultValue($today->modifyClone('last day of this month'));
		$form->addSelect('action', 'mall.accountant.export.action', [
			'overview'    => 'mall.accountant.export.actionList.overview',
			'controlList' => 'mall.accountant.export.actionList.controlList',
		]);

		$form->addSubmit('export', 'mall.accountant.export.export');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		try {
			$from = $values->from->setTime(0, 0, 0);
			$to   = $values->to->setTime(23, 59, 59);

			switch ($values->action) {
				case 'overview':
					$orders = $this->accountantService->exportOverview($this->country, $from, $to);

					$data = implode(';', array_map(function($str) {
							return '"' . $str . '"';
						}, ['CisloZakazky', 'Castka', 'Mena', 'VS', 'CisloZakaznika'])) . "\r";

					foreach ($orders as $order) {
						$data .= implode(';', array_map(function($str) {
								return '"' . $str . '"';
							}, $order)) . "\r";
					}

					CsvResponse::sendResponse('export_' . $this->country . '_' . $values->from->format('Y-m-d') . '_' . $values->to->format('Y-m-d') . '.csv', $data);
					exit;
				case 'controlList':
					$items = $this->accountantService->exportControlList($this->country, $from, $to);

					$data = implode(';', array_map(function($str) {
							return '"' . $str . '"';
						}, ['ID mall', 'Zákazník', 'Položka', 'Vytvořeno', 'Dodáno', 'DPH', 'Celkem', 'Provize',
							'Nákupní cena'])) . "\r";

					foreach ($items as $item) {
						$data .= implode(';', array_map(function($str) {
								return '"' . $str . '"';
							}, $item)) . "\r";
					}

					CsvResponse::sendResponse('export2_' . $this->country . '_' . $values->from->format('Y-m-d') . '_' . $values->to->format('Y-m-d') . '.csv', $data);
					exit;
			}

			return true;
		} catch (\Exception$e) {
			$form->addError($e->getMessage());
			$this->redrawControl('formErrors');
		}

		return false;
	}
}
