<?php declare(strict_types = 1);

namespace Mall\AdminModule\Components\Categories;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Mall\Model\Services\CategoriesService;
use Nette\Utils\ArrayHash;

class AllowCategoriesForm extends BaseControl
{
	protected string $country;

	protected CategoriesService $categories;

	public function __construct(string $country, CategoriesService $categories)
	{
		$this->country    = $country;
		$this->categories = $categories;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();
		$form->setShowLangSwitcher(false);

		$categories = [];
		$available  = [];
		foreach ($this->categories->getEr()->createQueryBuilder('c')
			         ->select('c.id, c.title, c.mallId, c.isAvailable')
			         ->where('c.country = :country')
			         ->setParameter('country', $this->country)
			         ->getQuery()->getArrayResult() as $row) {
			$categories[$row['id']] = $row['mallId'] . ' - ' . $row['title'];

			if ($row['isAvailable'])
				$available[] = $row['id'];
		}

		$form->addCheckboxList('categories', '', $categories)
			->setDefaultValue($available)
			->setTranslator(null);

		$form->addSaveCancelControl();

		$form->onSuccess[] = function(BaseForm $form, ArrayHash $values) use ($available) {
			try {
				$formCategories = $values->categories;

				$add = array_diff($formCategories, $available);
				if ($add) {
					$this->categories->getEr()->createQueryBuilder('c')->update()
						->set('c.isAvailable', 1)
						->where('c.id IN (:ids)')
						->setParameter('ids', array_values($add))
						->getQuery()->execute();
				}

				$remove = array_diff($available, $formCategories);
				if ($remove) {
					$this->categories->getEr()->createQueryBuilder('c')->delete()
						->where('c.id IN (:ids)')
						->setParameter('ids', array_values($remove))
						->getQuery()->execute();
				}

				$this->getPresenter()->flashMessageSuccess('default.saved');
			} catch (\Exception $e) {
				$this->getPresenter()->flashMessageDanger('default.error');
			}
		};

		return $form;
	}

	public function getCountry(): string { return $this->country; }
}
