<?php declare(strict_types = 1);

namespace Mall\AdminModule\Components\Deliveries;

use Core\Model\UI\BaseControl;
use EshopOrders\AdminModule\Model\Speditions;
use Mall\Model\Services\DeliveriesService;

class DeliveriesGrid extends BaseControl
{
	protected string $country;

	protected DeliveriesService $deliveriesService;

	protected Speditions $speditions;

	public function __construct(string $country, DeliveriesService $deliveriesService, Speditions $speditions)
	{
		$this->country           = $country;
		$this->deliveriesService = $deliveriesService;
		$this->speditions        = $speditions;
	}

	public function render(): void
	{
		$this->template->deliveryLink = $this->link('delivery!');
		$this->template->deliveries   = $this->getMallDeliveries();
		$this->template->speditions   = $this->getSpeditions();
		$this->template->render($this->getTemplateFile());
	}

	public function handleDelivery(): void
	{
		$country   = $this->getPost('country');
		$code      = $this->getPost('code');
		$spedition = $this->getPost('spedition');

		if ($country && $code && $this->deliveriesService->setEshopSpedition($country, (string) $code, $spedition))
			$this->getPresenter()->flashMessageSuccess('default.saved');
		else
			$this->getPresenter()->flashMessageDanger('default.error');

		$this->getPresenter()->redrawControl('flashes');
	}

	protected function getSpeditions(): array
	{
		return $this->speditions->getForSelectOption();
	}

	protected function getMallDeliveries(): array
	{
		return $this->deliveriesService->getExisting()[$this->country] ?? [];
	}
}
