<?php declare(strict_types = 1);

namespace Mall\AdminModule\Components\ForceToken;

use Core\Model\UI\BaseControl;
use Mall\Model\Services\ProductForceTokenService;

class ForceTokenGrid extends BaseControl
{
	protected string $country;

	protected ProductForceTokenService $forceTokenService;

	public function __construct(string $country, ProductForceTokenService $forceTokenService)
	{
		$this->country           = $country;
		$this->forceTokenService = $forceTokenService;
	}

	public function render(): void
	{
		$this->template->forceTokens = $this->forceTokenService->getUnUsed($this->country);
		$this->template->render($this->getTemplateFile());
	}

	public function handleRemove(int $id): void
	{
		if ($this->forceTokenService->remove($id, $this->country))
			$this->getPresenter()->flashMessageSuccess('default.saved');
		else
			$this->getPresenter()->flashMessageDanger('default.error');

		$this->getPresenter()->redrawControl('flashes');
		$this->redrawControl('wrap');
	}

	public function handleConfirmChange($id): void
	{
		if ($this->forceTokenService->confirmChange($id, $this->country))
			$this->getPresenter()->flashMessageSuccess('default.saved');
		else
			$this->getPresenter()->flashMessageDanger('default.error');

		$this->getPresenter()->redrawControl('flashes');
		$this->redrawControl('wrap');
	}
}
