<?php declare(strict_types = 1);

namespace Mall\AdminModule\Components\Labels;

use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use Mall\Model\Services\LabelsService;

class LabelsGrid extends BaseControl
{
	protected string $country;

	protected LabelsService $labelsService;

	public function __construct(string $country, LabelsService $labelsService)
	{
		$this->country       = $country;
		$this->labelsService = $labelsService;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ===============  Components
	 */

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();

		$qb = $this->labelsService->getEr()->createQueryBuilder('l')
			->andWhere('l.country = :country')
			->setParameters([
				'country' => $this->country,
			]);

		$grid->setDataSource($qb);

		$grid->addColumnText('mallId', 'mall.label.mallId')
			->setFilterText();
		$grid->addColumnText('title', 'mall.label.title')
			->setFilterText();
		$grid->addColumnStatus('show', 'mall.label.showInProduct')->setAlign('center')
			->addOption(1, 'default.publish')->setIcon('check')->setClass('btn-success')->setShowTitle(false)->endOption()
			->addOption(0, 'default.unPublish')->setIcon('times')->setClass('btn-danger')->setShowTitle(false)->endOption()
			->onChange[] = [$this, 'gridShowChange'];

		$grid->getColumn('mallId')->getElementPrototype('th')->class[] = 'w1nw';
		$grid->getColumn('show')->getElementPrototype('th')->class[]   = 'w1nw';

		return $grid;
	}

	public function gridShowChange($id, $value): void
	{
		$result = $this->labelsService->setShow((int) $id, (int) $value);

		if ($result)
			$this->getPresenter()->flashMessageSuccess('default.saved');
		else
			$this->getPresenter()->flashMessageDanger('default.error');
		$this->getPresenter()->payload->result = $result ? 'ok' : 'error';
		$this->getPresenter()->redrawControl('flashes');
		$this['grid']->redrawItem($id);
	}
}
