<?php declare(strict_types = 1);

namespace Mall\AdminModule\Components\Sellers;

use Core\Model\UI\BaseControl;
use EshopCatalog\AdminModule\Model\Sellers;
use Mall\Model\Entities\MallSeller;
use Mall\Model\Services\MallSellersService;

class SellersGrid extends BaseControl
{
	protected string $country;

	protected MallSellersService $mallSellers;

	protected Sellers $sellers;

	public function __construct(string $country, MallSellersService $mallSellers, Sellers $sellers)
	{
		$this->country     = $country;
		$this->mallSellers = $mallSellers;
		$this->sellers     = $sellers;
	}

	public function render(): void
	{
		$this->template->country    = $this->country;
		$this->template->sellerLink = $this->link('seller!');
		$this->template->mallSeller = $this->getMallSeller();
		$this->template->sellers    = $this->getSellers();
		$this->template->render($this->getTemplateFile());
	}

	public function handleSeller(): void
	{
		$seller = $this->getPost('seller');

		if ($this->mallSellers->setEshopSeller($this->country, $seller))
			$this->getPresenter()->flashMessageSuccess('default.saved');
		else
			$this->getPresenter()->flashMessageDanger('default.error');

		$this->getPresenter()->redrawControl('flashes');
	}

	protected function getSellers(): array
	{
		return $this->sellers->getOptionsForSelect();
	}

	protected function getMallSeller(): ?MallSeller
	{
		return $this->mallSellers->getExisting()[$this->country] ?? null;
	}
}
