<?php declare(strict_types = 1);

namespace Mall\AdminModule\Components;

use Core\AdminModule\Components\DataForm;
use EshopCatalog\AdminModule\Model\Manufacturers;

class SettingsForm extends DataForm
{
	public string $country = 'cs';

	/** @var Manufacturers|null @inject */
	public ?Manufacturers $manufacturers = null;

	public function getDataForInputs(): array
	{
		$key      = 'mall_' . $this->country;
		$titleKey = 'mall.settings.';

		return [
			[
				'section'     => 'base',
				'sectionName' => $titleKey . 'section.base',
				'name'        => $key . 'EnableSync',
				'title'       => [$titleKey . 'enableSync'],
				'type'        => 'bool',
			],
			[
				'section'     => 'manufacturers',
				'sectionName' => $titleKey . 'section.manufacturers',
				'name'        => $key . 'DisableManufacturers',
				'title'       => [$titleKey . 'disabledManufacturers'],
				'type'        => 'checkboxList',
				'items'       => $this->manufacturers->getOptionsForSelect(),
			],
		];
	}

}
