<?php declare(strict_types = 1);

namespace Mall\AdminModule\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use EshopCatalog\AdminModule\Components\Products\ProductsGrid;
use Core\Model\Entities\EntityManagerDecorator;
use Mall\Model\MallClients;
use Mall\Model\Services\LabelsService;
use Mall\Model\Services\ProductMapService;
use Mall\Model\Sync\SyncProduct;
use Nette\Http\Request;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ProductsGridSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;

	protected MallClients $mallClients;

	protected LabelsService $labelsService;

	protected ProductMapService $productMapService;

	protected Request $httpRequest;

	protected SyncProduct $syncProduct;

	protected static ?array $isInMall = null;

	public function __construct(EntityManagerDecorator $em, MallClients $mallClients, ProductMapService $productMapService, SyncProduct $syncProduct)
	{
		$this->em                = $em;
		$this->mallClients       = $mallClients;
		$this->productMapService = $productMapService;
		$this->syncProduct       = $syncProduct;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			ProductsGrid::class . '::onAttach' => 'onAttach',
		];
	}

	public function onAttach(ControlEvent $event): void
	{
		/** @var ProductsGrid $control */
		$control = &$event->control;

		foreach ($this->mallClients->getClients() as $client) {
			$control['grid']->addGroupSelectAction('mall.productsGrid.editExport_' . $client->getCountry(), [
				0 => 'default.no',
				1 => 'default.yes',
			])->onSelect[] = function(array $ids, $val) use ($client, $control) {
				if ($this->productMapService->changeActive($ids, $client->getCountry(), (int) $val)) {
					$this->syncProduct->processProductAvailabilities($ids);
					$control->getPresenter()->flashMessageSuccess('mall.messages.activeChanged');
				} else {
					$control->getPresenter()->flashMessageDanger('default.error');
				}

				$control->getPresenter()->redrawControl('flashes');
			};
		}
	}
}
