<?php declare(strict_types = 1);

namespace Mall\AdminModule\Presenters;

use Mall\AdminModule\Components\Accountant\ExportForm;
use Mall\AdminModule\Components\Accountant\IExportFormFactory;
use Mall\AdminModule\Components\Categories\AllowCategoriesForm;
use Mall\AdminModule\Components\Categories\CategoriesGrid;
use Mall\AdminModule\Components\Categories\IAllowCategoriesFormFactory;
use Mall\AdminModule\Components\Categories\ICategoriesGridFactory;
use Mall\AdminModule\Components\ForceToken\ForceTokenGrid;
use Mall\AdminModule\Components\ForceToken\IForceTokenGridFactory;
use Mall\AdminModule\Components\ISettingsForm2Factory;
use Mall\AdminModule\Components\ISettingsFormFactory;
use Mall\AdminModule\Components\Deliveries\DeliveriesGrid;
use Mall\AdminModule\Components\Deliveries\IDeliveriesGridFactory;
use Mall\AdminModule\Components\Labels\ILabelsGridFactory;
use Mall\AdminModule\Components\Labels\LabelsGrid;
use Mall\AdminModule\Components\Sellers\ISellersGridFactory;
use Mall\AdminModule\Components\Sellers\SellersGrid;
use Mall\AdminModule\Components\SettingsForm;
use Mall\AdminModule\Components\SettingsForm2;
use Mall\Model\MallClients;
use Nette\Application\UI\Multiplier;

class DefaultPresenter extends BasePresenter
{
	/** @var MallClients|null @inject */
	public ?MallClients $mallClients = null;

	protected function startup()
	{
		parent::startup();
		$this->setHeader('mall.title.mall', 'fas fa-store');
	}

	/*******************************************************************************************************************
	 * ======================== Handle
	 */

	public function handleEditAllowCategories(string $country): void
	{
		$this->template->modal   = 'allowCategoriesForm';
		$this->template->country = $country;
		$this->redrawControl('modal');
	}

	/*******************************************************************************************************************
	 * ======================== Action
	 */

	public function actionDefault()
	{
		$this->template->mallClients = array_keys($this->mallClients->getClients());
	}

	/*******************************************************************************************************************
	 * ======================== Component
	 */

	protected function createComponentSettingsForm(ISettingsFormFactory $factory): Multiplier
	{
		return new Multiplier(function($country) use ($factory): SettingsForm {
			$control          = $factory->create('');
			$control->country = $country;

			return $control;
		});
	}

	protected function createComponentCategoriesGrid(ICategoriesGridFactory $factory): Multiplier
	{
		return new Multiplier(function($country) use ($factory): CategoriesGrid {
			return $factory->create($country);
		});
	}

	protected function createComponentDeliveriesGrid(IDeliveriesGridFactory $factory): Multiplier
	{
		return new Multiplier(function($country) use ($factory): DeliveriesGrid {
			return $factory->create($country);
		});
	}

	protected function createComponentSellersGrid(ISellersGridFactory $factory): Multiplier
	{
		return new Multiplier(function($country) use ($factory): SellersGrid {
			return $factory->create($country);
		});
	}

	protected function createComponentLabelsGrid(ILabelsGridFactory $factory): Multiplier
	{
		return new Multiplier(function($country) use ($factory): LabelsGrid {
			return $factory->create($country);
		});
	}

	protected function createComponentForceTokensGrid(IForceTokenGridFactory $factory): Multiplier
	{
		return new Multiplier(function($country) use ($factory): ForceTokenGrid {
			return $factory->create($country);
		});
	}

	protected function createComponentAccountantExportForm(IExportFormFactory $factory): Multiplier
	{
		return new Multiplier(function($country) use ($factory): ExportForm {
			return $factory->create($country);
		});
	}

	protected function createComponentAllowCategoriesForm(IAllowCategoriesFormFactory $factory): Multiplier
	{
		return new Multiplier(function($country) use ($factory): AllowCategoriesForm {
			$control = $factory->create($country);

			$control->onAnchor[] = function() use ($control) {
				$control['form']->onSuccessSave[] = function() use ($control) {
					$this->getPresenter()->redrawControl('flashes');
					$this['categoriesGrid-' . $control->getCountry()]->redrawControl('wrap');
				};

				$control['form']->onSuccessSaveAndClose[] = function() use ($control) {
					$this->getPresenter()->payload->hideModal = true;
					$this->getPresenter()->redrawControl('flashes');
					$this['categoriesGrid-' . $control->getCountry()]->redrawControl('wrap');
				};

				$control['form']['saveControl']->closeModalOnCancel();
			};

			return $control;
		});
	}
}
