<?php declare(strict_types = 1);

namespace Mall\Console\Download;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Mall\Model\Sync\SyncCategories;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class Categories extends AbstractCommand
{
	/** @var SyncCategories|null @inject */
	public ?SyncCategories $syncCategories = null;

	protected function configure()
	{
		$this->setName('mall:download:categories')->setDescription('Download categories');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('<fg=white;bg=#007bff>MALL - Download categories</>');
		try {
			$this->syncCategories->downloadCategories();
			$output->writeLn('<info>[OK] - categories downloaded</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
