<?php declare(strict_types = 1);

namespace Mall\Console\Download;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Mall\Model\Sync\SyncLabels;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class Labels extends AbstractCommand
{
	/** @var SyncLabels|null @inject */
	public ?SyncLabels $syncLabels = null;

	protected function configure()
	{
		$this->setName('mall:download:labels')->setDescription('Download labels');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('<fg=white;bg=#007bff>MALL - Download labels</>');
		try {
			$this->syncLabels->downloadLabels();
			$output->writeLn('<info>[OK] - labels downloaded</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
