<?php declare(strict_types = 1);

namespace Mall\Console\Download;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Mall\Model\Sync\SyncOrders;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class Tracking extends AbstractCommand
{
	/** @var SyncOrders|null @inject */
	public ?SyncOrders $syncOrders = null;

	protected function configure()
	{
		$this->setName('mall:download:tracking')->setDescription('Download tracking data');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('<fg=white;bg=#007bff>MALL - Set tracking data to order</>');
		try {
			ini_set('memory_limit', '2G');
			$this->syncOrders->downloadTrackingData();
			$output->writeLn('<info>[OK] - tracking data downloaded</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
