<?php declare(strict_types = 1);

namespace Mall\Console\Sync;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Mall\Model\Sync\SyncDeliveries;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class Deliveries extends AbstractCommand
{
	/** @var SyncDeliveries|null @inject */
	public ?SyncDeliveries $syncDeliveries = null;

	protected function configure()
	{
		$this->setName('mall:sync:deliveries')->setDescription('Sync deliveries');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('<fg=white;bg=#007bff>MALL - Sync deliveries</>');
		try {
			$this->syncDeliveries->sync();
			$output->writeLn('<info>[OK] - deliveries synced</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
