<?php declare(strict_types = 1);

namespace Mall\Console\Sync;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Mall\Model\Sync\SyncProduct;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class UpdateAvailabilities extends AbstractCommand
{
	/** @var SyncProduct|null @inject */
	public ?SyncProduct $syncProducts = null;

	protected function configure()
	{
		$this->setName('mall:sync:update-availabilities')->setDescription('Update availabilities');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('<fg=white;bg=#007bff>MALL - Update availabilities</>');
		try {
			ini_set('memory_limit', '4G');
			$this->syncProducts->processAllAvailabilities();
			$output->writeLn('<info>[OK] - availabilities updated</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
