<?php declare(strict_types = 1);

namespace Mall\CronModule\Presenters;

use Nette\Utils\Json;

abstract class BasePresenter extends \Core\CronModule\Presenters\BasePresenter
{
	protected function responseOk(string $message = '')
	{
		$response = $this->getHttpResponse();
		$response->setContentType('application/json', 'utf-8');

		echo Json::encode([
			'result'  => 'ok',
			'message' => $message,
		]);

		exit;
	}

	public function responseData(array $data)
	{
		$response = $this->getHttpResponse();
		$response->setContentType('application/json', 'utf-8');

		echo Json::encode([
				'result' => 'ok',
			] + $data);

		exit;
	}

	protected function responseError(string $message = '', int $code = 500)
	{
		$response = $this->getHttpResponse();
		$response->setContentType('application/json', 'utf-8');
		$response->setCode($code);

		echo Json::encode([
			'result'  => 'error',
			'message' => $message,
		]);

		exit;
	}
}
